<?php
/**
 * Workflow Log Manager class
 *
 * @package CocoPolylangAutotranslate
 */

namespace COCO\PolylangAutotranslate\Workflow_Logs;

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Workflow Log Manager class
 */
class Workflow_Log_Manager {

	/**
	 * Maximum number of workflow logs to save in the database.
	 */
	const MAX_SAVED_WORKFLOW_LOGS = 10;

	/**
	 * Initialize the workflow log manager.
	 */
	public static function init(): void {
		add_action( 'coco_pa_prune_old_workflow_logs', [ __CLASS__, 'prune_old_workflow_logs' ] );
		if ( ! wp_next_scheduled( 'coco_pa_prune_old_workflow_logs' ) ) {
			wp_schedule_event( time(), 'daily', 'coco_pa_prune_old_workflow_logs' );
		}
	}

	/**
	 * Prune old workflow logs to keep the database clean.
	 */
	public static function prune_old_workflow_logs(): void {
		$workflow_logs = Workflow_Log_Crud::get_workflow_logs();

		if ( count( $workflow_logs ) > self::MAX_SAVED_WORKFLOW_LOGS ) {
			// Sort workflow logs by timestamp (id) in descending order
			usort(
				$workflow_logs,
				function ( $a, $b ) {
					return $b['id'] <=> $a['id'];
				}
			);

			$workflow_logs_to_keep = array_slice( $workflow_logs, 0, self::MAX_SAVED_WORKFLOW_LOGS );

			update_option( Workflow_Log_Crud::WORKFLOW_LOGS_OPTION_NAME, $workflow_logs_to_keep );
		}
	}
}
