<?php
/**
 * Workflow Logs Page class
 *
 * @package CocoPolylangAutotranslate
 */

namespace COCO\PolylangAutotranslate\Admin;

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Workflow Logs Page class
 */
class Workflow_Logs_Page {

	/**
	 * Render the workflow logs list page.
	 */
	public static function render(): void {
		$workflow_logs_table = new Workflow_Logs_Table();
		$workflow_logs_table->prepare_items();

		?>
		<div class="wrap">
			<h1><?php esc_html_e( 'Workflow Logs', 'coco-polylang-autotranslate' ); ?></h1>
			<form method="post">
				<?php
				$workflow_logs_table->display();
				?>
			</form>
		</div>
		<?php
	}
}
