<?php
/**
 * Admin Menu class
 *
 * Handles the main admin menu and subpages for the Coco Polylang Autotranslate plugin
 *
 * @package CocoPolylangAutotranslate
 */

namespace COCO\PolylangAutotranslate;

use COCO\PolylangAutotranslate\Admin\Workflow_Logs_Page;

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Admin Menu class
 */
class Admin_Menu {

	/**
	 * Initialize the admin functionality
	 *
	 * @return void
	 */
	public static function init(): void {
		add_action( 'admin_menu', [ __CLASS__, 'add_admin_menu' ] );
	}

	/**
	 * Add admin menu and subpages
	 *
	 * @return void
	 */
	public static function add_admin_menu(): void {
		// Main menu page
		add_menu_page(
			__( 'Coco Polylang Autotranslate', 'coco-polylang-autotranslate' ), // Page title
			__( 'Autotranslate', 'coco-polylang-autotranslate' ), // Menu title
			'manage_options', // Capability
			'coco-polylang-autotranslate', // Menu slug
			[ __CLASS__, 'render_main_page' ], // Callback
			'dashicons-translation', // Icon
			30 // Position
		);

		// Settings submenu page
		add_submenu_page(
			'coco-polylang-autotranslate', // Parent slug
			__( 'Settings', 'coco-polylang-autotranslate' ), // Page title
			__( 'Settings', 'coco-polylang-autotranslate' ), // Menu title
			'manage_options', // Capability
			'coco-polylang-autotranslate-settings', // Menu slug
			[ Settings_Page::class, 'render' ] // Callback
		);

		// Actions submenu page
		add_submenu_page(
			'coco-polylang-autotranslate', // Parent slug
			__( 'Actions', 'coco-polylang-autotranslate' ), // Page title
			__( 'Actions', 'coco-polylang-autotranslate' ), // Menu title
			'manage_options', // Capability
			'coco-polylang-autotranslate-actions', // Menu slug
			[ Actions_Page::class, 'render' ] // Callback
		);

		// Workflow Logs submenu page
		add_submenu_page(
			'coco-polylang-autotranslate', // Parent slug
			__( 'Workflow Logs', 'coco-polylang-autotranslate' ), // Page title
			__( 'Workflow Logs', 'coco-polylang-autotranslate' ), // Menu title
			'manage_options', // Capability
			'coco-polylang-autotranslate-workflow-logs', // Menu slug
			[ Workflow_Logs_Page::class, 'render' ] // Callback
		);
	}

	/**
	 * Render the main admin page
	 *
	 * @return void
	 */
	public static function render_main_page(): void {
		?>
		<div class="wrap">
			<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<div class="coco-polylang-autotranslate-main-dashboard">
				<div class="coco-polylang-autotranslate-card">
					<h2><?php esc_html_e( 'Welcome to Coco Polylang Autotranslate', 'coco-polylang-autotranslate' ); ?></h2>
					<p><?php esc_html_e( 'This plugin provides automatic translation features for Polylang, enhancing multilingual content management with AI-powered translations.', 'coco-polylang-autotranslate' ); ?></p>
					
					<div class="coco-polylang-autotranslate-quick-links">
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=coco-polylang-autotranslate-settings' ) ); ?>" class="button button-primary">
							<?php esc_html_e( 'Settings', 'coco-polylang-autotranslate' ); ?>
						</a>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=coco-polylang-autotranslate-actions' ) ); ?>" class="button button-secondary">
							<?php esc_html_e( 'Actions', 'coco-polylang-autotranslate' ); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}