<?php
/**
 * Enqueue class to handle admin styles for the Coco Polylang Autotranslate plugin.
 *
 * @package CocoPolylangAutotranslate
 */

namespace COCO\PolylangAutotranslate;

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Admin_Enqueue class.
 */
class Admin_Enqueue {

	/**
	 * Initialize hooks.
	 */
	public static function init(): void {
		add_action( 'admin_enqueue_scripts', [ __CLASS__, 'enqueue_admin_assets' ] );
	}

	/**
	 * Enqueue admin assets (CSS) for plugin pages.
	 *
	 * @param string $hook_suffix The current admin page.
	 */
	public static function enqueue_admin_assets( string $hook_suffix ): void {
		// Only load on our plugin pages
		if ( ! self::is_plugin_admin_page( $hook_suffix ) ) {
			return;
		}

		// Enqueue admin CSS
		wp_enqueue_style(
			'coco-polylang-autotranslate-admin',
			plugins_url( 'css/coco-polylang-autotranslate-admin.css', __FILE__ ),
			[],
			COCO_PA_VERSION ?? '1.0.0'
		);
	}

	/**
	 * Check if current page is one of our plugin admin pages.
	 *
	 * @param string $hook_suffix The current admin page.
	 * @return bool
	 */
	private static function is_plugin_admin_page( string $hook_suffix ): bool {
		// List of our plugin admin pages
		$plugin_pages = [
			'toplevel_page_coco-polylang-autotranslate',
			'coco-polylang-autotranslate_page_coco-polylang-autotranslate-settings',
			'coco-polylang-autotranslate_page_coco-polylang-autotranslate-actions',
		];

		return in_array( $hook_suffix, $plugin_pages, true );
	}
}
