<?php
/**
 * Plugin Name: Coco Polylang Autotranslate
 * Plugin URI: https://cobianzo.com/plugins/coco-polylang-autotranslate/
 * Description: A plugin that provides automatic translation features for Polylang, enhancing multilingual content management
 * Version: 1.0.0
 * Author: cobianzo
 * Author URI: https://cobianzo.com
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: coco-polylang-autotranslate
 * Domain Path: /languages
 * Requires at least: 6.0
 * Requires PHP: 8.1
 *
 * @package CocoPolylangAutotranslate
 */

use COCO\PolylangAutotranslate\Actions_Logic;
use COCO\PolylangAutotranslate\Rest\Workflow_Logs_Api;
use COCO\PolylangAutotranslate\Workflow_Logs\Workflow_Log_Crud;

// Prevent direct access to this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Define plugin constants
 */
define( 'COCO_PA_VERSION', '1.0.0' );
define( 'COCO_PA_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'COCO_PA_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * Initialize plugin
 *
 * @return void
 */
function coco_pa_init(): void {

	// includes
	require_once COCO_PA_PLUGIN_DIR . 'inc/admin/class-admin-enqueue.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/polylang/class-rest-api-extension.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/polylang/class-polylang-helpers.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/admin/class-admin-menu.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/admin/settings-page/class-settings-page.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/admin/actions-page/class-actions-page.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/admin/actions-page/class-actions-logic.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/admin/workflow-logs-page/class-workflow-logs-page.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/admin/workflow-logs-page/class-workflow-logs-table.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/n8n/class-n8n-connection.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/workflow-logs/class-workflow-log-crud.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/workflow-logs/class-workflow-log-manager.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/chunks/class-chunk-manager.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/rest/class-workflow-logs-api.php';
	require_once COCO_PA_PLUGIN_DIR . 'inc/rest/class-chunk-transients-api.php';

	// Initialize classes
	COCO\PolylangAutotranslate\Admin_Enqueue::init();
	COCO\PolylangAutotranslate\Polylang\REST_API_Extension::init();
	COCO\PolylangAutotranslate\Admin_Menu::init();
	COCO\PolylangAutotranslate\Settings_Page::init();
	COCO\PolylangAutotranslate\Actions_Page::init();
	COCO\PolylangAutotranslate\Actions_Logic::init();

	// Workflow Logs
	COCO\PolylangAutotranslate\Workflow_Logs\Workflow_Log_Manager::init();

	// Rest API
	COCO\PolylangAutotranslate\Rest\Workflow_Logs_Api::init();
	COCO\PolylangAutotranslate\Rest\Chunk_Transients_Api::init();
}

// Initialize the plugin
coco_pa_init();

// Debugging functions.
// phpcs:disable
if ( ! function_exists( 'dd' ) ) {
	/**
	 * Debug function to dump variables
	 *
	 * @param mixed $var Variable to dump
	 * @return void
	 */
	function dd( mixed $var ): void {
		echo '<pre>';
		var_dump( $var );
		echo '</pre>';
	}
}

if ( ! function_exists( 'ddie' ) ) {
	/**
	 * Debug function to dump variables and die
	 *
	 * @param mixed $var Variable to dump
	 * @return never
	 */
	function ddie( mixed $var = '' ): never {
		dd( $var );
		wp_die();
		exit; // Asegura que la función nunca retorna
	}
}
// phpcs:enable
